import numpy as np
import pandas as pd
import os

np.set_printoptions(suppress=True)


def runyan(seeds, path, path1):
    # %% Import Data

    data = np.loadtxt(path)
    dataDamaged = np.loadtxt(path1)
     # %% Define Toeplitz matrices
    l = data.shape[0]
    N = data.shape[1]
    TS = 23;  # Time shift

    Ri, RiDamaged = [], []
    for ii in range(2 * TS - 1):
        Ri.append(1 / (N - ii) * data[:, :-TS] @ data[:, TS:].T)
        RiDamaged.append(1 / (N - ii) * dataDamaged[:, :-TS] @ dataDamaged[:, TS:].T)

    r = np.arange(TS - 1, -1, -1)
    c = np.arange(TS - 1, 2 * TS - 1)
    ID = linalg.toeplitz(c, r)  # serve solo per tenere traccia dei blocchi in Toeplitz
    Tb, TbDamaged = [], []
    # Tb : Toeplitz
    Tb = np.vstack([np.hstack([Ri[_o] for _o in range(TS - 1 + _l, _l - 1, -1)]) for _l in range(TS)])

    TbDamaged = np.vstack([np.hstack([RiDamaged[_o] for _o in range(TS - 1 + _l, _l - 1, -1)]) for _l in range(TS)])

    # %% CALCOLO INDICE YAN

    Active_space = 2

    U0, S0, V0 = np.linalg.svd(Tb);
    U1, S11, V1 = np.linalg.svd(TbDamaged);

    NullSpace = U0[:, Active_space:];
    ActiveSpace = U1[:, :Active_space];

    #  Matriceresidui=NullSpace*SpazioAttivo';
    Residues = NullSpace.T @ ActiveSpace

    U, S, V = np.linalg.svd(Residues.T);

    YanDamageIndex = np.linalg.norm(Residues);

    print(f'Yan Damage Index : {YanDamageIndex}')

    return YanDamageIndex
#-------------------------------------------------
os.getcwd()
os.chdir(r'D:\desktop\Jupternotebook\Thesis\Database\20')
o = os.listdir()
o.sort(key=lambda x : int(x.split("_")[2]))
# len(o) 8242
#------------------------------------------------
alldata = []
for seed in range(1,5001):
    s_1 = [s for s in o if (f'seed_{seed}_Damage') in s]
    if len(s_1) == 1:
       # print('un broken')
        path = s_1[0]
        path1 = s_1[0]
    if len(s_1) == 2:
        #print('broken')
        path = s_1[0]
        path1 = s_1[1]
    if seed % 50 == 0:
        print(seed)
        print (path,path1)
    seeds = seed
    yan = runyan(seeds,path,path1)
    alldata.append(yan)
np.shape(alldata)  #(5000 * 1)
np.savetxt("Yan's_20dB.txt",alldata)

df1 = pd.read_csv(r"D:\桌面\Jupternotebook\Thesis\Database\20\20db final.csv")
df2 = pd.read_csv(r"D:\桌面\Jupternotebook\Thesis\Database\20\Yan's 60.txt",header= None)
df1.loc[:,'Yan']=df2

df1.to_csv("situation_B_20dB.txt")
